state BloodMoonSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity, quileg_stream		: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect,CustomEffect2						: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("monster_dettlaff_monster.bnk") )
		{
			theSound.SoundLoadBank( "monster_dettlaff_monster.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_yennefer.bnk") )
		{
			theSound.SoundLoadBank( "magic_yennefer.bnk", false );
		}
		
		if ( parent.spell_name == 'blood_moon_trap' )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
				parent.AddTimer('rotate_towards_target', 0.0001, true );
			}
		}
		else
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
		
		cast_spells_valerie_devour();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		if ( animEventName == 'cast_throw' )
		{
			cast_spells_bloodmoon();
		}
		if ( animEventName == 'cast_end' )
		{
			cast_spells_blood_moon_trap();
			cast_spells_valerie_devour_act();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_bloodmoon()
	{
		var basePos, pos			: Vector;
		var rot 					: EulerAngles;
		var spikeEnt				: CEntity;
		var PositionLocal			: Vector;
		var PositionGlobal			: Vector;
		var polarAngle, unitAngle 	: float;
		var radius, angle		 	: float;
		
		switch( parent.spell_name )
		{
			case 'blood_cone':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = thePlayer.GetWorldRotation();
				
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					//rotation.Yaw += 90;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\blood_moon_cone.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('cone_lv3');
					main_effect.DestroyAfter(10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\blood_moon_cone2.w2ent";
					
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					effect_entity.PlayEffect('cone'); 
					effect_entity.StopAllEffectsAfter(0.5);
					effect_entity.DestroyAfter(10);
					
					actors = thePlayer.GetNPCsAndPlayersInCone( 9, VecHeading( castDir ), 60, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					for (i=0; i<actors.Size(); i+=1)	
					{
						CustomEffect.effectType = EET_BloodLeash;
						CustomEffect.creator = thePlayer;
						CustomEffect.sourceName = thePlayer.GetName();
						CustomEffect.duration = GetMagicVigil().get_magic_spellpower() * 5;
						actors[i].AddEffectCustom(CustomEffect);
						
						CustomEffect2.effectType = EET_Bleeding;
						CustomEffect2.creator = thePlayer;
						CustomEffect2.sourceName = thePlayer.GetName();
						CustomEffect2.duration = RandRangeF(4.0, 0.9);;
						actors[i].AddEffectCustom(CustomEffect2);
						
						//theGame.witcherLog.AddMessage("duration " + (string)( GetMagicVigil().get_magic_spellpower() * 5 ) );
					}
				
					thePlayer.SoundEvent("magic_yennefer_q310_spell_03");
					thePlayer.SoundEvent("monster_dettlaff_monster_movement_whoosh_large");
		
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					
					parent.GotoState( 'Vigil_Dreaming' );
				}
				
				break;
			case 'valerie_stream':
				{
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					cast_spells_stream_valerie();
				}
				
				break;
			default:		
				break;
		}
	}
	
	
	private function cast_spells_blood_moon_trap()
	{
		var vortex 	: W3BloodVortex;
	
		if ( parent.spell_name == 'blood_moon_trap' )
		{
			theGame.GetEntitiesByTag('blood_vortex_spells',ents_destroy);
			for( i=0; i<ents_destroy.Size(); i+=1 )
			{
				ents_destroy[i].AddTimer('destroy_blood_vortex',0.0f);
			} 	
			
			parent.templatename = "dlc\magicspellsrev\data\entities\blood_moon_trap.w2ent";
		
			duration = 10;
			duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
		
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*6;
		
			position = find_position_spells( position );
		
			vortex = (W3BloodVortex)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), thePlayer.GetWorldRotation());
			vortex.AddTimer('destroy_blood_vortex', duration );
			vortex.AddTag('blood_vortex_spells');
			vortex.AddTag( 'spells_from_sign' );
			
			Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
		}
	}
	
	private function cast_spells_valerie_devour()
	{
		if ( parent.spell_name == 'valerie_devour' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) 
				&& VecDistance(thePlayer.GetWorldPosition(), parent.actor.GetWorldPosition()) <= 5 )
			{
				GetMagicEffectLeft().PlayEffect('ma_valerie_');
				GetMagicEffectLeft().PlayEffect('ma_valerie_');
			
			}
			else
			{
				thePlayer.SetBehaviorVariable( 'bStopSign', 1.f );
				thePlayer.SetBehaviorVariable( 'axiiResisted', 1.f );
				
				parent.GotoState( 'Vigil_Dreaming' );
			}
		}
	}
	
	private function cast_spells_valerie_devour_act()
	{
		if ( parent.spell_name == 'valerie_devour' )
		{
			effect_entity = parent.actor.CreateFXEntityAtPelvis( 'bloodmoon_effects', true );
			effect_entity.PlayEffect('devour_drain', GetMagicEffectLeft() );
			effect_entity.StopAllEffects();
			effect_entity.PlayEffect('devour_hit');
			effect_entity.DestroyAfter(5.0);
			
			effect_entity = parent.actor.CreateFXEntityAtPelvis( 'runeword_4', true );
			effect_entity.DestroyAfter(5.0);
			
			duration = MaxF( 3, MinF( 8, GetMagicVigil().get_magic_spellpower() * 4 ) );
			//theGame.witcherLog.AddMessage("DURAION  =  " + duration );
			
			damage_value = MaxF( parent.actor.GetMaxHealth()*0.10, parent.actor.GetMaxHealth() * GetMagicVigil().get_magic_spellpower() * 0.05 );
			damage_value = ClampF ( damage_value, parent.actor.GetMaxHealth()*0.05, parent.actor.GetMaxHealth()*0.20 );
			damage_value += damage_value * get_overall_mult();
			if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
			{
				damage_value *= RandRangeF(1.1, 0.9);
			}
			
			damage_action = new W3DamageAction in this;
			damage_action.Initialize(thePlayer,parent.actor,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
			damage_action.SetProcessBuffsIfNoDamage(true);
			damage_action.AddDamage( theGame.params.DAMAGE_NAME_DIRECT, sp_direct_dmg_mod() * damage_value );
			//damage_action.AddEffectInfo( EET_SpellsSlowDownAverage, duration ); 
			damage_action.AddEffectInfo( EET_Stagger ); 
			
			parent.drinkhealth( ClampF ( damage_value, 0, GetWitcherPlayer().GetMaxHealth()*0.1 ) );
			
			if ( spells_can_dismember( parent.actor ) )
			{
				damage_action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( damage_action );
			delete damage_action;
		
			if( !parent.actor.IsAlive() )
			{
				if ( !parent.actor.UsesEssence() )
				{
					effect_entity = parent.actor.CreateFXEntityAtPelvis( 'blood_explode', true );
					effect_entity.PlayEffect('blood_explode');
					effect_entity.DestroyAfter(5.0);
				}
			}
		
			Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
		}
	}
		
	private entry function cast_spells_stream_valerie()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victimburn, victim					: CActor;
		var damage 								: float;
		var channelDmg 							: SAbilityAttributeValue;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity, effect, ground		: CEntity;
		var coll, normal						: Vector;
		var lastpos 							: Vector;
		var lastpos2 							: Vector;
		var entities							: array<CGameplayEntity>;
		var	timestamp							: float;
		var colls								: array< name >;
		var customeffect						: SCustomEffectParams;
		var results 							: array<SRaycastHitResult>;
		var res, effect_expl					: CEntity;
		var ind 								: int;
		var min 								: float;
		var can_burn							: bool;
		var tscale								: float;
		
		tscale = theGame.GetTimeScale();
		
		thePlayer.playerAiming.StartAiming(NULL);
		
		effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'bloodmoon_effects' ), thePlayer.playerAiming.GetThrowPosition(), thePlayer.GetWorldRotation() );
		effectentity.AddTag('spells_stream_collision');
		
		GetMagicEffectLeft().PlayEffect('ma_valerie_');GetMagicEffectLeft().PlayEffect('ma_valerie_');
		//GetMagicEffectLeft().PlayEffect('ma_valerie_1');
		
		GetMagicEffectLeft().SoundEvent("monster_dettlaff_monster_combat_trap_trapped_LP");
		
		/*
		GetMagicEffectLeft().SoundEvent("sign_axii_target_guard_loop_end");
		GetMagicEffectLeft().SoundEvent("sign_axii_target_guard_loop_end");
		GetMagicEffectLeft().SoundEvent("sign_axii_target_guard_loop_end");
		GetMagicEffectLeft().SoundEvent("magic_yennefer_necromancy_loop_start");
		GetMagicEffectLeft().SoundEvent("magic_yennefer_necromancy_loop_start");
		GetMagicEffectLeft().SoundEvent("magic_yennefer_necromancy_loop_start");
		*/
		
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{	
				/*
				if ( tscale != theGame.GetTimeScale() )
				{
					thePlayer.playerAiming.RemoveAimingSloMo();
				}
				*/
				
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 40 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
				
				results.Clear();
				FindActorsAtLine( position, thePlayer.playerAiming.GetThrowPosition(), 0.3f, results );
				
				if ( results.Size() > 0 )
				{
					min = results[0].distance;
					ind = 0;
					for( i=1; i<results.Size(); i+=1 )
					{
						if(results[i].distance < min)
						{
							min = results[i].distance;
							ind = i;
						}
					}
				}
				
				if(results[ind].component)
				{
					res = results[ind].component.GetEntity();
					
					victim = (CActor)res;
			
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = MaxF( victim.GetMaxHealth()*0.01, victim.GetMaxHealth() * GetMagicVigil().get_magic_spellpower() * get_spellpower_mult() );
						damage = ClampF ( damage, victim.GetMaxHealth()*0.01, victim.GetMaxHealth()*0.05 );
						damage += damage * get_streams_increase();
						damage += damage * get_overall_mult();
											
						if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
						{
							damage *= RandRangeF(1.1, 0.9);
						}
											
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						
						//if ( RandF() < 0.1 )
						{
							/*
							customeffect.effectType = EET_Swarm;
							customeffect.creator = thePlayer;
							customeffect.sourceName = "spells_valerie";
							customeffect.duration = 0.5;
							customeffect.customFXName = 'bla';
							victim.AddEffectCustom(customeffect);
							*/
							damage_action_stream.AddEffectInfo( EET_SpellsSlowDownCritical, 0.5 ); 
						}
						
						damage_action_stream.AddDamage(theGame.params.DAMAGE_NAME_DIRECT, sp_direct_dmg_mod() * damage );
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
						damage_action_stream.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
					
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						if ( VecDistance(thePlayer.GetWorldPosition(), victim.GetWorldPosition()) < 7 )
						{
							GetWitcherPlayer().GainStat( BCS_Vitality, ClampF ( damage, 0, GetWitcherPlayer().GetMaxHealth()*0.0022 ) );
							 
							theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffectSingle('drain_stream', GetMagicEffectLeft() );
							theGame.GetEntityByTag( 'spells_stream_collision' ).StopEffect('drain_stream');
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
						
						if( !victim.IsAlive() )
						{
							if ( !victim.UsesEssence() )
							{
								effect = victim.CreateFXEntityAtPelvis( 'blood_explode', true );
								effect.PlayEffect('blood_explode');
								effect.DestroyAfter(5.0);
							}
							effect = victim.CreateFXEntityAtPelvis( 'runeword_4', true );
							effect.DestroyAfter(2);
						}
						
						theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffect('smoke');
					}
				}
				
				
				if( theGame.GetWorld().SweepTest( position + castDir, thePlayer.playerAiming.GetThrowPosition(), 0.1, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopAllEffects();
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(thePlayer.playerAiming.GetThrowPosition());
				}
				/*
				if ( ( EngineTimeToFloat( theGame.GetEngineTime() ) - timestamp ) > 0.15 )
				{
					timestamp = EngineTimeToFloat( theGame.GetEngineTime() );
					quileg_stream.PlayEffect('quileg_stream_act', theGame.GetEntityByTag( 'spells_stream_collision' ) );
					quileg_stream.PlayEffect('quileg_stream_act', theGame.GetEntityByTag( 'spells_stream_collision' ) );
				}
				*/
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	
	event OnLeaveState( nextStateName : name )
	{
	}
}